import React, {Component} from 'react';
import PropTypes from 'prop-types';
import DocumentsList from "./DocumentsList";
import {compose} from "redux";
import {graphql} from "react-apollo";
import {authUserQuery, documentsQuery} from "../../../../api/queries";

export class DocumentsListContainer extends Component {

  constructor(props) {
    super(props)
  }

  render() {
    return (
      <DocumentsList {...this.props} />
    )
  }
}

export default compose(
  graphql(documentsQuery, {
    variables: {
      filtri: "",
      pagination: {
        limit: 50, offset: 0
      }
    }
  }),
  graphql(authUserQuery, {name: 'utenteSessione'})
)(DocumentsListContainer);

DocumentsListContainer.defaultProps = {};

DocumentsListContainer.propTypes = {};
